<?php
include_once DOL_DOCUMENT_ROOT . "/core/boxes/modules_boxes.php";

class bankcashwidget extends ModeleBoxes
{
    public $boxcode="bankcashwidget";
    public $boximg="fa-university";
    public $boxlabel='Bank & Cash Widget';
    public $lang='businessdashboard@businessdashboard';
    public $depends=array('businessdashboard');
    public $widgettype='graph';

    public function __construct(DoliDB $db,$param=''){parent::__construct($db,$param);$this->param=$param;}

    public function loadBox($max=5)
    {
        global $langs,$user;
        if(!isModEnabled('businessdashboard')) return;
        if(empty($user->rights->businessdashboard->VIEW_BANK_CASH)) return;

        $this->info_box_head=array('text'=>$langs->trans("Bank & Cash Information"),'subpicto'=>'fa-university');
        $this->info_box_contents=array();

        $date=dol_print_date(dol_now(),'day');
        $revenue=150000;$expenses=80000;$balance=$revenue-$expenses;

        $this->info_box_contents[]=array(
            0=>array('td'=>'align="left"','text'=>$langs->trans("Date")),
            1=>array('td'=>'align="right"','text'=>$langs->trans("Revenue")),
            2=>array('td'=>'align="right"','text'=>$langs->trans("Expenses")),
            3=>array('td'=>'align="right"','text'=>$langs->trans("Balance"))
        );
        $this->info_box_contents[]=array(
            0=>array('td'=>'align="left"','text'=>$date),
            1=>array('td'=>'align="right"','text'=>number_format($revenue,0,'.',',')),
            2=>array('td'=>'align="right"','text'=>number_format($expenses,0,'.',',')),
            3=>array('td'=>'align="right"','text'=>number_format($balance,0,'.',','))
        );
    }

    public function showBox($head=null,$contents=null,$nooutput=0)
    {
        if(empty($this->info_box_head) || empty($this->info_box_contents)) return '';
        $out=parent::showBox($head??$this->info_box_head,$contents??$this->info_box_contents,1);
        $labels=json_encode(["Revenue","Expenses","Balance"]);
        $values=json_encode([150000,80000,70000]);
        $out.='<div style="height:150px;width:100%;"><canvas id="bankcashChart"></canvas></div>';
        $out.="
        <script src=\"https://cdn.jsdelivr.net/npm/chart.js\"></script>
        <script>
        new Chart(document.getElementById('bankcashChart'),{
            type:'bar',
            data:{labels:$labels,datasets:[{data:$values,backgroundColor:['#4CAF50','#F44336','#2196F3']}]},
            options:{responsive:true,maintainAspectRatio:false}
        });
        </script>";
        if(empty($nooutput)) print $out;
        return $out;
    }
}