<?php
include_once DOL_DOCUMENT_ROOT . "/core/boxes/modules_boxes.php";

class leavewidget extends ModeleBoxes
{
    public $boxcode    = "leavewidget";
    public $boximg     = "fa-calendar-alt";
    public $boxlabel   = 'Leave Widget';
    public $lang       = 'businessdashboard@businessdashboard';
    public $depends    = array('businessdashboard');
    public $widgettype = 'graph';

    // Optional: store chart data per instance
    private $chart_labels = array();
    private $chart_values = array();

    public function __construct(DoliDB $db, $param = '')
    {
        parent::__construct($db, $param);
        $this->param = $param;
    }

    public function loadBox($max = 5)
    {
        global $langs, $user;

        // Skip entirely if module disabled or user lacks rights
        if (!isModEnabled('businessdashboard')) return;
        if (empty($user->rights->businessdashboard->VIEW_LEAVE)) return;

        $this->max = $max;
        $this->info_box_head = array(
            'text'     => $langs->trans("Leave Information"),
            'subpicto' => 'fa-calendar-alt',
        );
        $this->info_box_contents = array();

        // Demo values (replace with live queries when ready)
        $date        = dol_print_date(dol_now(), 'day');
        $taken       = 12;
        $remaining   = 8;
        $annualQuota = $taken + $remaining;

        // Header row
        $this->info_box_contents[] = array(
            0 => array('td' => 'align="left"',  'text' => $langs->trans("Date")),
            1 => array('td' => 'align="right"', 'text' => $langs->trans("Leave Taken")),
            2 => array('td' => 'align="right"', 'text' => $langs->trans("Leave Remaining")),
            3 => array('td' => 'align="right"', 'text' => $langs->trans("Annual Quota"))
        );

        // Data row
        $this->info_box_contents[] = array(
            0 => array('td' => 'align="left"',  'text' => $date),
            1 => array('td' => 'align="right"', 'text' => number_format($taken, 0, '.', ',')),
            2 => array('td' => 'align="right"', 'text' => number_format($remaining, 0, '.', ',')),
            3 => array('td' => 'align="right"', 'text' => number_format($annualQuota, 0, '.', ','))
        );

        // Store chart data for showBox
        $this->chart_labels = array("Leave Taken", "Leave Remaining");
        $this->chart_values = array($taken, $remaining);
    }

    public function showBox($head = null, $contents = null, $nooutput = 0)
    {
        // If no content (permissions missing or module disabled), skip entirely
        if (empty($this->info_box_head) || empty($this->info_box_contents)) {
            return '';
        }

        // Render the table
        $out = parent::showBox(
            $head ?? $this->info_box_head,
            $contents ?? $this->info_box_contents,
            1 // prevent auto output so we can append chart
        );

        // Chart data
        $labels = json_encode(!empty($this->chart_labels) ? $this->chart_labels : array("Leave Taken","Leave Remaining"));
        $values = json_encode(!empty($this->chart_values) ? $this->chart_values : array(12,8));

        // Compact chart container
        $out .= '<div style="height:150px; width:100%;"><canvas id="leaveChart"></canvas></div>';

        // Chart.js script
        $out .= "
        <script src=\"https://cdn.jsdelivr.net/npm/chart.js\"></script>
        <script>
        (function(){
            var ctx = document.getElementById('leaveChart');
            if (!ctx) return;
            new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: $labels,
                    datasets: [{
                        data: $values,
                        backgroundColor: ['#8BC34A','#FF9800']
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        title: { display: true, text: 'Leave Status' },
                        legend: { display: true }
                    },
                    cutout: '60%'
                }
            });
        })();
        </script>
        ";

        if (empty($nooutput)) print $out;
        return $out;
    }
}