<?php
include_once DOL_DOCUMENT_ROOT . "/core/boxes/modules_boxes.php";

class productswidget extends ModeleBoxes
{
    public $boxcode    = "productswidget";
    public $boximg     = "fa-box";
    public $boxlabel   = 'Products Widget';
    public $lang       = 'businessdashboard@businessdashboard';
    public $depends    = array('businessdashboard');
    public $widgettype = 'graph';

    public function __construct(DoliDB $db, $param = '')
    {
        parent::__construct($db, $param);
        $this->param = $param;
    }

    public function loadBox($max = 5)
    {
        global $langs, $user;

        // Skip entirely if module disabled or user lacks rights
        if (!isModEnabled('businessdashboard')) return;
        if (empty($user->rights->businessdashboard->VIEW_PRODUCTS)) return;

        $this->info_box_head = array(
            'text'     => $langs->trans("Products Information"),
            'subpicto' => 'fa-box',
        );
        $this->info_box_contents = array();

        // Demo values
        $date = dol_print_date(dol_now(), 'day');
        $pA   = 120;
        $pB   = 45;
        $pC   = 75;

        // Header row
        $this->info_box_contents[] = array(
            0 => array('td'=>'align="left"',  'text'=>$langs->trans("Date")),
            1 => array('td'=>'align="right"', 'text'=>"Product A"),
            2 => array('td'=>'align="right"', 'text'=>"Product B"),
            3 => array('td'=>'align="right"', 'text'=>"Product C")
        );

        // Data row
        $this->info_box_contents[] = array(
            0 => array('td'=>'align="left"',  'text'=>$date),
            1 => array('td'=>'align="right"', 'text'=>number_format($pA,0,'.',',')),
            2 => array('td'=>'align="right"', 'text'=>number_format($pB,0,'.',',')),
            3 => array('td'=>'align="right"', 'text'=>number_format($pC,0,'.',','))
        );

        // Store demo chart data for showBox
        $this->chart_labels = ["Product A","Product B","Product C"];
        $this->chart_values = [120,45,75];
    }

    public function showBox($head = null, $contents = null, $nooutput = 0)
    {
        // If no content (permissions missing), skip entirely
        if (empty($this->info_box_head) || empty($this->info_box_contents)) return '';

        // Render the table
        $out = parent::showBox(
            $head ?? $this->info_box_head,
            $contents ?? $this->info_box_contents,
            1
        );

        // Chart data
        $labels = json_encode($this->chart_labels ?? ["Product A","Product B","Product C"]);
        $values = json_encode($this->chart_values ?? [120,45,75]);

        // Compact chart container
        $out .= '<div style="height:150px; width:100%;"><canvas id="productsChart"></canvas></div>';

        // Chart.js script
        $out .= "
        <script src=\"https://cdn.jsdelivr.net/npm/chart.js\"></script>
        <script>
        new Chart(document.getElementById('productsChart'), {
            type: 'bar',
            data: {
                labels: $labels,
                datasets: [{
                    data: $values,
                    backgroundColor: ['#673AB7','#009688','#FF5722']
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    title: { display: true, text: 'Product Stock Levels' },
                    legend: { display: false }
                },
                indexAxis: 'y'
            }
        });
        </script>
        ";

        if (empty($nooutput)) print $out;
        return $out;
    }
}