<?php
include_once DOL_DOCUMENT_ROOT . "/core/boxes/modules_boxes.php";

class saleswidget extends ModeleBoxes
{
    public $boxcode="saleswidget";
    public $boximg="fa-chart-line";
    public $boxlabel='Sales Widget';
    public $lang='businessdashboard@businessdashboard';
    public $depends=array('businessdashboard');
    public $widgettype='graph';

    public function __construct(DoliDB $db,$param=''){parent::__construct($db,$param);$this->param=$param;}

    public function loadBox($max=5)
    {
        global $langs,$user;
        if(!isModEnabled('businessdashboard')) return;
        if(empty($user->rights->businessdashboard->VIEW_GLOBAL_SALES) && empty($user->rights->businessdashboard->VIEW_LOCAL_SALES)) return;

        $this->info_box_head=array('text'=>$langs->trans("Sales Information"),'subpicto'=>'fa-chart-line');
        $this->info_box_contents=array();

        $date=dol_print_date(dol_now(),'day');
        $global=200000;$local=50000;

        $this->info_box_contents[]=array(
            0=>array('td'=>'align="left"','text'=>$langs->trans("Date")),
            1=>array('td'=>'align="right"','text'=>$langs->trans("Global Sales")),
            2=>array('td'=>'align="right"','text'=>$langs->trans("Local Sales"))
        );
        $this->info_box_contents[]=array(
            0=>array('td'=>'align="left"','text'=>$date),
            1=>array('td'=>'align="right"','text'=>number_format($global,0,'.',',')),
            2=>array('td'=>'align="right"','text'=>number_format($local,0,'.',','))
        );
    }

    public function showBox($head=null,$contents=null,$nooutput=0)
    {
        if(empty($this->info_box_head) || empty($this->info_box_contents)) return '';
        $out=parent::showBox($head??$this->info_box_head,$contents??$this->info_box_contents,1);
        $labels=json_encode(["Global Sales","Local Sales"]);
        $values=json_encode([200000,50000]);
        $out.='<div style="height:150px;width:100%;"><canvas id="salesChart"></canvas></div>';
        $out.="
        <script src=\"https://cdn.jsdelivr.net/npm/chart.js\"></script>
        <script>
        new Chart(document.getElementById('salesChart'),{
            type:'pie',
            data:{labels:$labels,datasets:[{data:$values,backgroundColor:['#2196F3','#FFC107']}]},
            options:{responsive:true,maintainAspectRatio:false}
        });
        </script>";
        if(empty($nooutput)) print $out;
        return $out;
    }
}