<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../../main.inc.php';
/*
 * Security check
 */
if (!isModEnabled('dashboardreports')) {
    accessforbidden('Module not enabled');
}
if (empty($user->rights->dashboardreports->read)) {
    accessforbidden('You do not have permission to access Dashboard Reports');
}

require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/functions.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/report.lib.php';

global $db;
$langs->load("admin");
$langs->load("bills");
$langs->load("main");

llxHeader('', 'Business Intelligence Dashboard');

// Time filter
$filter = $_GET['time_filter'] ?? 'all';
$current_year = date('Y');
$current_month = date('m');
$current_datetime = date('m/d/Y h:i A');
$currency = 'NGN';

// Date range logic
switch ($filter) {
    case 'this_month':
        $start_date = "$current_year-$current_month-01";
        $end_date = date("Y-m-t");
        break;
    case 'this_year':
        $start_date = "$current_year-01-01";
        $end_date = "$current_year-12-31";
        break;
    case 'q1':
        $start_date = "$current_year-01-01";
        $end_date = "$current_year-03-31";
        break;
    case 'q2':
        $start_date = "$current_year-04-01";
        $end_date = "$current_year-06-30";
        break;
    case 'q3':
        $start_date = "$current_year-07-01";
        $end_date = "$current_year-09-30";
        break;
    case 'q4':
        $start_date = "$current_year-10-01";
        $end_date = "$current_year-12-31";
        break;
    case 'custom':
        $start_input = dol_escape_htmltag($_GET['start_date'] ?? '');
        $end_input = dol_escape_htmltag($_GET['end_date'] ?? '');
        $start_date = $start_input ?: "$current_year-01-01";
        $end_date = $end_input ?: "$current_year-12-31";
        break;
    default:
        $start_date = "2000-01-01";
        $end_date = date("Y-m-d");
        break;
}

// Filter dropdown
print '<form method="GET" style="margin-bottom:20px;">';
print 'View by: <select name="time_filter" onchange="this.form.submit()" style="padding:5px;">';
$filters = [
    'all' => 'All Time',
    'this_month' => 'This Month',
    'this_year' => 'This Year',
    'q1' => 'Q1 (Jan–Mar)',
    'q2' => 'Q2 (Apr–Jun)',
    'q3' => 'Q3 (Jul–Sep)',
    'q4' => 'Q4 (Oct–Dec)',
    'custom' => 'Custom Range'
];
foreach ($filters as $key => $label) {
    $selected = ($filter === $key) ? ' selected' : '';
    print "<option value=\"$key\"$selected>$label</option>";
}
print '</select>';

if ($filter === 'custom') {
    print '&nbsp;&nbsp;&nbsp;';
    print 'From: <input type="date" name="start_date" value="' . $start_input . '" style="padding:5px;">';
    print '&nbsp;';
    print 'To: <input type="date" name="end_date" value="' . $end_input . '" style="padding:5px;">';
    print '&nbsp;';
    print '<input type="submit" value="Apply" style="padding:5px 10px;">';
}
print '</form>';

// Financial summary calculations
$total_sales = 0;
$total_purchases = 0;
$total_margin = 0;
$total_expenses = 0;
$net_profit = 0;
$profit_percent = 0;
$profit_arrow = '';

// Sales
$sql_sales = "SELECT SUM(total_ttc) AS total FROM " . MAIN_DB_PREFIX . "facture WHERE fk_statut = 2 AND datef BETWEEN '$start_date' AND '$end_date'";
$res_sales = $db->query($sql_sales);
if ($res_sales && ($obj = $db->fetch_object($res_sales))) {
    $total_sales = $obj->total ?? 0;
}

// Margin and Purchases
$sql_margin = "SELECT subprice, buy_price_ht, qty FROM " . MAIN_DB_PREFIX . "facturedet WHERE fk_facture IN (
    SELECT rowid FROM " . MAIN_DB_PREFIX . "facture WHERE fk_statut = 2 AND datef BETWEEN '$start_date' AND '$end_date')";
$res_margin = $db->query($sql_margin);
if ($res_margin) {
    while ($obj = $db->fetch_object($res_margin)) {
        $total_margin += ($obj->subprice - $obj->buy_price_ht) * $obj->qty;
        $total_purchases += $obj->buy_price_ht * $obj->qty;
    }
}

// Salary
$sql_salary = "SELECT SUM(amount) AS total FROM " . MAIN_DB_PREFIX . "payment_salary WHERE datep BETWEEN '$start_date' AND '$end_date'";
$res_salary = $db->query($sql_salary);
if ($res_salary && ($obj = $db->fetch_object($res_salary))) {
    $total_expenses += $obj->total ?? 0;
}

// Expense reports
$sql_expense = "SELECT SUM(total_ttc) AS total FROM " . MAIN_DB_PREFIX . "expensereport WHERE fk_statut = 6 AND date_valid BETWEEN '$start_date' AND '$end_date'";
$res_expense = $db->query($sql_expense);
if ($res_expense && ($obj = $db->fetch_object($res_expense))) {
    $total_expenses += $obj->total ?? 0;
}

// Final profit
$net_profit = $total_margin - $total_expenses;
//$profit_percent = $total_margin > 0 ? round(($net_profit / $total_margin) * 100, 2) : 0;
$profit_percent = $total_expenses > 0 ? round(($net_profit / $total_expenses) * 100, 2) : 0;
$profit_arrow = $net_profit < 0 ? '▼' : ($net_profit > 0 ? '▲' : '');

// Monthly income, expense, and profit
$month_labels = [];
$monthly_income = [];
$monthly_expense = [];
$monthly_profit = [];

for ($m = 1; $m <= 12; $m++) {
    $start = "$current_year-" . str_pad($m, 2, '0', STR_PAD_LEFT) . "-01";
    $end = date("Y-m-t", strtotime($start));
    $month_labels[] = date("M", strtotime($start));

    $income = 0;
    $expense = 0;

    // Margin (income)
    $sql_margin = "SELECT subprice, buy_price_ht, qty FROM " . MAIN_DB_PREFIX . "facturedet WHERE fk_facture IN (
        SELECT rowid FROM " . MAIN_DB_PREFIX . "facture WHERE fk_statut = 2 AND datef BETWEEN '$start' AND '$end')";
    $res_margin = $db->query($sql_margin);
    if ($res_margin) {
        while ($obj = $db->fetch_object($res_margin)) {
            $income += ($obj->subprice - $obj->buy_price_ht) * $obj->qty;
        }
    }

    // Salary
    $sql_salary = "SELECT SUM(amount) AS total FROM " . MAIN_DB_PREFIX . "payment_salary WHERE datep BETWEEN '$start' AND '$end'";
    $res_salary = $db->query($sql_salary);
    if ($res_salary && ($obj = $db->fetch_object($res_salary))) {
        $expense += $obj->total ?? 0;
    }

    // Expense reports
    $sql_expense = "SELECT SUM(total_ttc) AS total FROM " . MAIN_DB_PREFIX . "expensereport WHERE fk_statut = 6 AND date_valid BETWEEN '$start' AND '$end'";
    $res_expense = $db->query($sql_expense);
    if ($res_expense && ($obj = $db->fetch_object($res_expense))) {
        $expense += $obj->total ?? 0;
    }

    $monthly_income[] = round($income, 2);
    $monthly_expense[] = round($expense, 2);
    $monthly_profit[] = round($income - $expense, 2);
}

$month_labels_json = json_encode($month_labels);
$monthly_income_json = json_encode($monthly_income);
$monthly_expense_json = json_encode($monthly_expense);
$profit_data_json = json_encode($monthly_profit);

// Location-based expense
$location_expense_labels = [];
$location_expense_data = [];

$sql_top_locations = "SELECT w.ref AS location_name, SUM(e.total_ttc) AS total
    FROM " . MAIN_DB_PREFIX . "expensereport e
    LEFT JOIN " . MAIN_DB_PREFIX . "entrepot w ON w.rowid = CAST(e.business_location AS UNSIGNED)
    WHERE e.fk_statut IN (6)
      AND e.date_valid BETWEEN '$start_date' AND '$end_date'
      AND e.business_location IS NOT NULL
    GROUP BY e.business_location
    HAVING SUM(e.total_ttc) > 5000
    ORDER BY total DESC
    LIMIT 15";

$res_locations = $db->query($sql_top_locations);
if ($res_locations) {
    while ($obj = $db->fetch_object($res_locations)) {
        $location_expense_labels[] = $obj->location_name;
        $location_expense_data[] = round($obj->total, 2);
    }
}

$location_expense_labels = json_encode($location_expense_labels);
$location_expense_data = json_encode($location_expense_data);

// Quarterly profit
$quarter_labels = ["Q1", "Q2", "Q3", "Q4"];
$quarter_profit = [];

for ($q = 1; $q <= 4; $q++) {
    $start_month = ($q - 1) * 3 + 1;
    $end_month = $start_month + 2;

    $start = "$current_year-" . str_pad($start_month, 2, '0', STR_PAD_LEFT) . "-01";
    $end = date("Y-m-t", strtotime("$current_year-" . str_pad($end_month, 2, '0', STR_PAD_LEFT) . "-01"));

    $margin = 0;
    $expenses = 0;

    $sql_margin = "SELECT subprice, buy_price_ht, qty FROM " . MAIN_DB_PREFIX . "facturedet WHERE fk_facture IN (
        SELECT rowid FROM " . MAIN_DB_PREFIX . "facture WHERE fk_statut = 2 AND datef BETWEEN '$start' AND '$end')";
    $res_margin = $db->query($sql_margin);
    if ($res_margin) {
        while ($obj = $db->fetch_object($res_margin)) {
            $margin += ($obj->subprice - $obj->buy_price_ht) * $obj->qty;
        }
    }

    $sql_salary = "SELECT SUM(amount) AS total FROM " . MAIN_DB_PREFIX . "payment_salary WHERE datep BETWEEN '$start' AND '$end'";
    $res_salary = $db->query($sql_salary);
    if ($res_salary && ($obj = $db->fetch_object($res_salary))) {
        $expenses += $obj->total ?? 0;
    }

    $sql_expense = "SELECT SUM(total_ttc) AS total FROM " . MAIN_DB_PREFIX . "expensereport WHERE fk_statut = 6 AND date_valid BETWEEN '$start' AND '$end'";
    $res_expense = $db->query($sql_expense);
    if ($res_expense && ($obj = $db->fetch_object($res_expense))) {
        $expenses += $obj->total ?? 0;
    }

    $quarter_profit[] = round($margin - $expenses, 2);
}

$quarter_labels_json = json_encode($quarter_labels);
$quarter_profit_json = json_encode($quarter_profit);

// Year-over-year comparison
$year_labels = [];
$revenue_by_year = [];
$expense_by_year = [];
$profit_by_year = [];

for ($i = 2; $i >= 0; $i--) {
    $year = $current_year - $i;
    $year_labels[] = strval($year);

    $start = "$year-01-01";
    $end = "$year-12-31";

    $revenue = 0;
    $expenses = 0;

    // Revenue from invoices
    $sql_margin = "SELECT subprice, buy_price_ht, qty FROM " . MAIN_DB_PREFIX . "facturedet 
                   WHERE fk_facture IN (
                       SELECT rowid FROM " . MAIN_DB_PREFIX . "facture 
                       WHERE fk_statut = 2 AND datef BETWEEN '$start' AND '$end')";
    $res_margin = $db->query($sql_margin);
    if ($res_margin) {
        while ($obj = $db->fetch_object($res_margin)) {
            $revenue += ($obj->subprice - $obj->buy_price_ht) * $obj->qty;
        }
    }

    // Salaries
    $sql_salary = "SELECT SUM(amount) AS total FROM " . MAIN_DB_PREFIX . "payment_salary 
                   WHERE datep BETWEEN '$start' AND '$end'";
    $res_salary = $db->query($sql_salary);
    if ($res_salary && ($obj = $db->fetch_object($res_salary))) {
        $expenses += $obj->total ?? 0;
    }

    // Expense reports
    $sql_expense = "SELECT SUM(total_ttc) AS total FROM " . MAIN_DB_PREFIX . "expensereport 
                    WHERE fk_statut = 6 AND date_valid BETWEEN '$start' AND '$end'";
    $res_expense = $db->query($sql_expense);
    if ($res_expense && ($obj = $db->fetch_object($res_expense))) {
        $expenses += $obj->total ?? 0;
    }

    $revenue_by_year[] = round($revenue, 2);
    $expense_by_year[] = round($expenses, 2);
    $profit_by_year[] = round($revenue - $expenses, 2);
}

$total_profit = array_sum($profit_by_year);

if ($total_profit > 0) {
    $profit_percentages = array_map(function($val) use ($total_profit) {
        return round(($val / $total_profit) * 100, 1);
    }, $profit_by_year);
} else {
    // fallback when no data yet
    $profit_percentages = array_fill(0, count($profit_by_year), 0);
}
$max_profit_index = array_keys($profit_by_year, max($profit_by_year))[0];

$year_labels_json = json_encode($year_labels);
$profit_percent_json = json_encode($profit_percentages);
$margin_color = "#ff9800";
$profit_bar_color = $net_profit < 0 ? "#dc143c" : "#006400";
?>


//<!-- Dashboard Header -->
<?php // end PHP block ?>
<!-- Dashboard Header -->
<h1 style="text-align:center; font-size:28px; margin-bottom:10px;">Business Intelligence Dashboard</h1>
<h2 style="text-align:center; font-size:20px; margin-bottom:20px;">Financial Summary Table and Chart</h2>
<p style="text-align:center; font-style:italic; color:#555;">
  This data is real-time — showing values as of <strong><?= $current_datetime ?> WAT</strong>
</p>
<?php // resume PHP if needed ?>

<!-- Financial Summary Table -->
<table style="width:100%; margin-top:20px; border-collapse:collapse; text-align:center;">
    <tr style="background-color:#f0f0f0;">
        <th>Total Sales</th><th>Total Purchases</th><th>Total Margin</th><th>Total Expenses</th><th>Profit/Loss</th>
    </tr>
    <tr>
        <td><?= $currency ?> <?= number_format($total_sales, 2) ?></td>
        <td><?= $currency ?> <?= number_format($total_purchases, 2) ?></td>
        <td><?= $currency ?> <?= number_format($total_margin, 2) ?></td>
        <td><?= $currency ?> <?= number_format($total_expenses, 2) ?></td>
        <td style="color:black;"><?= $profit_arrow ?> <?= $currency ?> <?= number_format($net_profit, 2) ?> (<?= $profit_percent ?>%)</td>
    </tr>
</table>

<!-- Row 1: Financial Summary Chart + Pie Chart + Profit Status -->
<div style="display:flex; justify-content:space-between; gap:20px; margin-top:40px; margin-bottom:30px;">
    <!-- Bar Chart -->
    <div style="flex: 1.1; height: 360px; padding: 15px 15px 30px 15px; background: #f9f9f9; border-radius: 8px; box-shadow: 2px 2px 10px rgba(0,0,0,0.2);">
        <h3 style="text-align:center;">Financial Summary Chart</h3>
        <canvas id="financialChart"></canvas>
    </div>

    <!-- Pie Chart + Profit Status -->
    <div style="flex: 1; display: flex; flex-direction: row; align-items: center; justify-content: space-between; padding: 15px; background: #fff; border:1px solid #ccc; border-radius:6px;">
        <!-- Pie Chart -->
        <div style="flex: 1;">
            <h4 style="text-align:center;">Margin vs Expenses</h4>
            <canvas id="pieChart" style="max-height:240px;"></canvas>
        </div>

        <!-- Profit Status Label -->
        <?php
        $status_label = '';
        $status_emoji = '';
        if ($profit_percent < 0) {
            $status_label = 'Loss Zone'; $status_emoji = '😟';
        } elseif ($profit_percent == 0) {
            $status_label = 'Break Even'; $status_emoji = '😐';
        } elseif ($profit_percent <= 5) {
            $status_label = 'Weak Profit'; $status_emoji = '😕';
        } elseif ($profit_percent <= 10) {
            $status_label = 'Fair Profit Status'; $status_emoji = '😌';
        } elseif ($profit_percent <= 20) {
            $status_label = 'Encouraging Profit Status'; $status_emoji = '🙂';
        } elseif ($profit_percent <= 25) {
            $status_label = 'Comfortable Profit Status'; $status_emoji = '😃';
        } else {
            $status_label = 'Healthy Profit Status'; $status_emoji = '😄';
        }
        ?>
        <div style="flex: 0.9; text-align:center; padding-left:15px;">
            <div style="font-size:40px;"><?= $status_emoji ?></div>
            <div style="font-weight:bold; font-size:16px; color:#333;"><?= $status_label ?></div>
            <div style="font-size:14px; color:#777;"><?= $profit_percent ?>% Profit</div>
        </div>
    </div>
</div>

<!-- Row 2: Monthly Profit Line Chart + Quarterly Table + Chart -->
<div style="display:flex; justify-content:space-between; gap:20px; margin-top:20px;">
    <!-- Monthly Profit Line Chart -->
    <div style="flex: 1.1; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
        <h4 style="text-align:center;">Monthly Profit Trend (Jan–Dec)</h4>
        <canvas id="lineChart" style="max-height:240px;"></canvas>
    </div>

    <!-- Quarterly Profit Table + Chart -->
    <div style="margin-top:30px; padding:20px; background:#fff; border:1px solid #ccc; border-radius:6px; width:51%;">
        <h3 style="text-align:center;">Quarter-by-Quarter Profit Comparison</h3>
        <table class="noborder" style="width:100%; margin-bottom:20px;">
            <tr style="background:#f0f0f0;">
                <?php foreach ($quarter_labels as $label): ?>
                    <th style='text-align:center;'><?= $label ?></th>
                <?php endforeach; ?>
            </tr>
            <tr>
                <?php foreach ($quarter_profit as $value): ?>
                    <td style='text-align:center;'>₦<?= number_format($value, 2) ?></td>
                <?php endforeach; ?>
            </tr>
        </table>
        <canvas id="quarterChart" style="max-height:300px; width:20%; display:block;"></canvas>
    </div>
</div>

<!-- Year-over-Year Comparison -->
<h3>Year-over-Year Comparison</h3>
<canvas id="yearComparisonChart" style="max-height: 400px;"></canvas>

<!-- Monthly Income vs Expense -->
<div class="box" style="padding:20px;">
    <h3 style="text-align:center;">Month-by-Month Income vs Expense</h3>
    <canvas id="monthLineChart" style="max-height:300px;"></canvas>
</div>

<!-- Top Locations by Expense -->
<div style="flex: 0.9; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
    <h4 style="text-align:center;">Top Locations by Expense</h4>
    <canvas id="locationExpenseChart" style="max-height:240px;"></canvas>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<script>
Chart.register(ChartDataLabels);

// Financial Summary Chart
new Chart(document.getElementById("financialChart"), {
    type: "bar",
    data: {
        labels: ["Total Sales", "Total Purchases", "Total Margin", "Total Expenses", "Profit/Loss"],
        datasets: [{
            label: "Amount (₦)",
            data: [<?= $total_sales ?>, <?= $total_purchases ?>, <?= $total_margin ?>, <?= $total_expenses ?>, <?= $net_profit ?>],
            backgroundColor: [
                "#000080", "#800000", "<?= $margin_color ?>", "#555555", "<?= $profit_bar_color ?>"
            ],
            borderRadius: 4,
            borderSkipped: false,
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { display: false },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        const label = context.dataset.label || '';
                        const value = context.parsed.y ?? context.parsed;
                        return label + ": ₦" + value.toLocaleString();
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return "₦" + value.toLocaleString();
                    }
                }
            }
        }
    }
});

// Monthly Profit Line Chart
new Chart(document.getElementById("lineChart"), {
    type: "line",
    data: {
        labels: <?= $month_labels_json ?>,
        datasets: [{
            label: "Monthly Profit",
            data: <?= $profit_data_json ?>,
            borderColor: "#006400",
            backgroundColor: "rgba(0,100,0,0.1)",
            borderWidth: 2,
            tension: 0.3,
            fill: true,
            pointRadius: 4,
            pointHoverRadius: 7
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { position: "top" },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        return "₦" + context.parsed.toLocaleString();
                    }
                }
            },
            datalabels: {
                anchor: 'end',
                align: 'top',
                formatter: function(value) {
                    return '₦' + value.toLocaleString();
                },
                font: { weight: 'bold' },
                color: '#006400'
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return "₦" + value.toLocaleString();
                    }
                }
            }
        }
    }
});

// Quarterly Profit Chart
new Chart(document.getElementById("quarterChart"), {
    type: "bar",
    data: {
        labels: <?= $quarter_labels_json ?>,
        datasets: [{
            label: "Net Profit (₦)",
            data: <?= $quarter_profit_json ?>,
            backgroundColor: ["#1e90ff", "#32cd32", "#ffa500", "#dc143c"],
            borderRadius: 4,
            borderSkipped: false
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { display: false },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        const label = context.dataset.label || '';
                        const value = context.parsed.y ?? context.parsed;
                        return label + ": ₦" + value.toLocaleString();
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return "₦" + value.toLocaleString();
                    }
                }
            }
        }
    }
});
</script>

<script>
  // Year-over-Year Comparison Chart
  new Chart(document.getElementById("yearComparisonChart"), {
    type: "bar",
    data: {
      labels: ["Revenue", "Expense", "Profit"],
      datasets: [
        {
          label: "<?= $year_labels[0] ?>",
          data: [<?= $revenue_by_year[0] ?>, <?= $expense_by_year[0] ?>, <?= $profit_by_year[0] ?>],
          backgroundColor: ["#1e90ff", "#1e90ff", <?= $max_profit_index === 0 ? '"#32cd32"' : '"#555555"' ?>]
        },
        {
          label: "<?= $year_labels[1] ?>",
          data: [<?= $revenue_by_year[1] ?>, <?= $expense_by_year[1] ?>, <?= $profit_by_year[1] ?>],
          backgroundColor: ["#ffa500", "#ffa500", <?= $max_profit_index === 1 ? '"#32cd32"' : '"#555555"' ?>]
        },
        {
          label: "<?= $year_labels[2] ?>",
          data: [<?= $revenue_by_year[2] ?>, <?= $expense_by_year[2] ?>, <?= $profit_by_year[2] ?>],
          backgroundColor: ["#dc143c", "#dc143c", <?= $max_profit_index === 2 ? '"#32cd32"' : '"#555555"' ?>]
        }
      ]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      scales: {
        y: {
          beginAtZero: true,
          ticks: {
            callback: function(value) {
              return "₦" + value.toLocaleString();
            }
          }
        }
      }
    }
  });

  // Margin vs Expense Pie Chart
  new Chart(document.getElementById("pieChart"), {
    type: "doughnut",
    data: {
      labels: ["Total Margin", "Total Expenses"],
      datasets: [{
        data: [<?= $total_margin ?>, <?= $total_expenses ?>],
        backgroundColor: ["#ff9800", "#dc143c"],
        borderColor: ["#fff", "#fff"],
        borderWidth: 2
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      cutout: "50%",
      plugins: {
        legend: { position: "bottom" },
        tooltip: {
          callbacks: {
            label: function(context) {
              return context.label + ": ₦" + context.parsed.toLocaleString();
            }
          }
        }
      }
    }
  });

  // Monthly Income vs Expense Line Chart
  new Chart(document.getElementById("monthLineChart"), {
    type: 'line',
    data: {
      labels: <?= $month_labels_json ?>,
      datasets: [
        {
          label: 'Income (₦)',
          data: <?= $monthly_income_json ?>,
          borderColor: '#4caf50',
          backgroundColor: 'rgba(76, 175, 80, 0.2)',
          fill: true,
          tension: 0.3,
          borderWidth: 2,
          pointRadius: 5,
          pointHoverRadius: 7
        },
        {
          label: 'Expense (₦)',
          data: <?= $monthly_expense_json ?>,
          borderColor: '#f44336',
          backgroundColor: 'rgba(244, 67, 54, 0.2)',
          fill: true,
          tension: 0.3,
          borderWidth: 2,
          pointRadius: 5,
          pointHoverRadius: 7
        }
      ]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: true },
        tooltip: {
          callbacks: {
            label: function(context) {
              return context.label + ": ₦" + context.parsed.toLocaleString();
            }
          }
        },
        datalabels: {
          anchor: 'end',
          align: function(context) {
            return context.dataset.label === 'Income (₦)' ? 'top' : 'bottom';
          },
          formatter: function(value) {
            return '₦' + value.toLocaleString();
          },
          font: { weight: 'bold' },
          color: function(context) {
            return context.dataset.label === 'Income (₦)' ? '#4caf50' : '#f44336';
          }
        }
      },
      scales: {
        y: {
          beginAtZero: true,
          ticks: {
            callback: function(value) {
              return "₦" + value.toLocaleString();
            }
          }
        }
      }
    }
  });

  // Location Expense Chart
  new Chart(document.getElementById("locationExpenseChart"), {
    type: "bar",
    data: {
      labels: <?= $location_expense_labels ?>,
      datasets: [{
        label: "Expense (₦)",
        data: <?= $location_expense_data ?>,
        backgroundColor: "#007bff",
        borderRadius: 4,
        borderSkipped: false
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: { display: false },
        tooltip: {
          callbacks: {
            label: function(context) {
              const label = context.dataset.label || '';
              const value = context.parsed.y ?? context.parsed;
              return label + ": ₦" + value.toLocaleString();
            }
          }
        }
      },
      scales: {
        y: {
          beginAtZero: true,
          ticks: {
            callback: function(value) {
              return "₦" + value.toLocaleString();
            }
          }
        }
      }
    }
  });
</script>
<?php llxFooter(); ?>