<?php
/**
 *  \file       dashboardreports/dashboardreportsindex.php
 *  \ingroup    dashboardreports
 *  \brief      Home page of Dashboard Reports top menu
 */

// Dolibarr context
$res = 0;
if (!$res && file_exists("../main.inc.php")) $res = @include "../main.inc.php";
if (!$res && file_exists("../../main.inc.php")) $res = @include "../../main.inc.php";
if (!$res && file_exists("../../../main.inc.php")) $res = @include "../../../main.inc.php";
/*


if (!$res) die("Include of main fails");

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';

// Load translation files required by the page
$langs->loadLangs(array("dashboardreports@dashboardreports"));

/*
 * Security check
 */
if (!isModEnabled('dashboardreports')) {
    accessforbidden('Module not enabled');
}
if (empty($user->rights->dashboardreports)) {
    accessforbidden();
}

/*
 * View
 */
llxHeader('', $langs->trans("DashboardReportsArea"));

// Welcome message
print '<h2>'.$langs->trans("Welcome To Analytics World").'</h2>';
print '<p>'.$langs->trans("Your Central Hub For Insights").'</p>';

// Load Chart.js
print '<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>';

// Chart containers
print '<div style="display:flex; flex-wrap:wrap; gap:20px;">';

// Bar chart
print '<div style="flex:1; min-width:300px; border:1px solid #ccc; padding:10px;">
        <h3>'.$langs->trans("Top 7 Best Sellers").'</h3>
        <canvas id="barChart"></canvas>
      </div>';

// Line chart
print '<div style="flex:1; min-width:300px; border:1px solid #ccc; padding:10px;">
        <h3>'.$langs->trans("Income Vs Expense Jan - Jun").'</h3>
        <canvas id="lineChart"></canvas>
      </div>';

// Pie chart
print '<div style="flex:1; min-width:300px; border:1px solid #ccc; padding:10px;">
        <h3>'.$langs->trans("Quarterly Revenue Distribution").'</h3>
        <canvas id="pieChart"></canvas>
      </div>';

// Table
print '<div style="flex:1; min-width:300px; border:1px solid #ccc; padding:10px;">
        <h3>'.$langs->trans("Bank Accounts By Location").'</h3>
        <table class="noborder" style="width:100%;">
            <tr><th>'.$langs->trans("Location").'</th><th>'.$langs->trans("Total").'</th></tr>
            <tr><td>Lagos</td><td>150,000</td></tr>
            <tr><td>Abuja</td><td>120,000</td></tr>
            <tr><td>Port Harcourt</td><td>100,000</td></tr>
            <tr><td>Kano</td><td>80,000</td></tr>
        </table>
      </div>';

print '</div>';

// Chart.js scripts
print '<script>
// Bar chart
new Chart(document.getElementById("barChart"), {
    type: "bar",
    data: {
        labels: ["P1","P2","P3","P4","P5","P6","P7"],
        datasets: [{
            label: "Sales",
            data: [120,95,80,70,65,60,55],
            backgroundColor: "rgba(75, 192, 192, 0.6)"
        }]
    }
});

// Line chart
new Chart(document.getElementById("lineChart"), {
    type: "line",
    data: {
        labels: ["Jan","Feb","Mar","Apr","May","Jun"],
        datasets: [
            {
                label: "Income",
                data: [5000,7000,6500,8000,7500,9000],
                borderColor: "rgba(54, 162, 235, 1)",
                fill: false
            },
            {
                label: "Expense",
                data: [4000,4500,5000,5500,6000,6500],
                borderColor: "rgba(255, 99, 132, 1)",
                fill: false
            }
        ]
    }
});

// Pie chart
new Chart(document.getElementById("pieChart"), {
    type: "pie",
    data: {
        labels: ["Q1","Q2","Q3","Q4"],
        datasets: [{
            data: [25,30,20,25],
            backgroundColor: [
                "rgba(255, 99, 132, 0.6)",
                "rgba(54, 162, 235, 0.6)",
                "rgba(255, 206, 86, 0.6)",
                "rgba(75, 192, 192, 0.6)"
            ]
        }]
    }
});
</script>';

// Guidance message
print '<p style="margin-top:30px; font-style:italic;">'.$langs->trans("Use the Left Menu For more Insights and Details of your Business").'</p>';

llxFooter();
$db->close();