<?php

require_once '../../main.inc.php'; // Adjust path if needed

header('Content-Type: text/html; charset=UTF-8');
global $db, $langs, $user;

$monthly_profits = []; // or fetch from DB

// Example structure:
$monthly_profits = [
  '2025-08' => 18000,
  '2025-09' => 20000,
  '2025-10' => 22000,
  '2025-11' => 17500,
];

$current_year = date("Y");
$actual_months = [];
$actual_profits = [];

// 🔢 Monthly Profit Calculation
for ($m = 10; $m <= 11; $m++) {
    $month = str_pad($m, 2, '0', STR_PAD_LEFT);
    $start = "$current_year-$month-01";
    $end = date("Y-m-t", strtotime($start));
    $margin = $expenses = 0;

   $db_prefix = defined('MAIN_DB_PREFIX') ? rtrim(MAIN_DB_PREFIX, '_') . '_' : 'ok_';

$sql_margin = "SELECT subprice, buy_price_ht, qty FROM {$db_prefix}facturedet 
               WHERE fk_facture IN (
                   SELECT rowid FROM {$db_prefix}facture 
                   WHERE fk_statut = 2 AND datef BETWEEN '$start' AND '$end')";
                   
    $res_margin = $db->query($sql_margin);
    if ($res_margin) {
        while ($obj = $db->fetch_object($res_margin)) {
            $margin += ($obj->subprice - $obj->buy_price_ht) * $obj->qty;
        }
    }

$db_prefix = defined('MAIN_DB_PREFIX') ? rtrim(MAIN_DB_PREFIX, '_') . '_' : 'ok_';

$sql_salary = "SELECT SUM(amount) AS total FROM {$db_prefix}payment_salary 
               WHERE datep BETWEEN '$start' AND '$end'";
$res_salary = $db->query($sql_salary);
if ($res_salary && ($obj = $db->fetch_object($res_salary))) {
    $expenses += $obj->total ?? 0;
}

$sql_expense = "SELECT SUM(total_ttc) AS total FROM {$db_prefix}expensereport 
                WHERE fk_statut = 6 AND date_valid BETWEEN '$start' AND '$end'";
$res_expense = $db->query($sql_expense);
if ($res_expense && ($obj = $db->fetch_object($res_expense))) {
    $expenses += $obj->total ?? 0;
}

$actual_months[] = date("M", strtotime($start));
$actual_profits[] = round($margin - $expenses, 2);
}

// 🔢 Normalize Monthly Data
$monthly_labels = $actual_months;
$monthly_profit = $actual_profits;
$month_profit_pairs = array_combine($monthly_labels, $monthly_profit);
arsort($month_profit_pairs);
$top_months = array_slice($month_profit_pairs, 0, 3, true);

$monthly_labels = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
$monthly_profit = [];
foreach ($monthly_labels as $label) {
    $monthly_profit[] = $month_profit_pairs[$label] ?? 0;
}

$monthly_labels_json = json_encode($monthly_labels);
$monthly_profit_json = json_encode($monthly_profit);
$recent_profits = array_slice($monthly_profit, -3);
$recent_avg = round(array_sum($recent_profits) / count($recent_profits), 2);
$forecast = $recent_avg;
$next_month = date("M", strtotime("first day of next month"));

// 🔮 Multi-Month Forecasting — Enhanced with Year Rollover
$current_year = date('Y');
$current_month_index = date('n'); // 1 = Jan, 12 = Dec

$next_months = [];
for ($i = 1; $i <= 3; $i++) {
    $next_months[] = date('F', strtotime("+$i month"));
}
$forecast_values = [$forecast, round($forecast * 1.05), round($forecast * 0.92)];
$forecast_alerts = [];

foreach ($next_months as $i => $month) {
    $month_index = date('n', strtotime($month));
    $year_offset = ($month_index < $current_month_index) ? 1 : 0;
    $year = $current_year + $year_offset;

    $value = $forecast_values[$i];
    $deviation = $recent_avg > 0 ? round((($value - $recent_avg) / $recent_avg) * 100, 1) : 0;
    $direction = $deviation > 0 ? 'increase' : ($deviation < 0 ? 'drop' : 'no change');
    $trend = $deviation > 0 ? 'Trending upward.' : ($deviation < 0 ? 'Monitor margin pressure.' : 'Stable outlook.');

    $forecast_alerts[] = "📉 Forecast for <strong>{$month} {$year}</strong>: ₦" . number_format($value, 0) .
                         " vs. avg ₦" . number_format($recent_avg, 0) . " — " . abs($deviation) . "% {$direction}. {$trend}";
}

// 🔍 Historical Averages
$average_product_profits = [];
$average_location_profits = [];

$db_prefix = defined('MAIN_DB_PREFIX') ? rtrim(MAIN_DB_PREFIX, '_') . '_' : 'ok_';

$sql_avg_prod = "SELECT p.label, AVG((fd.subprice - fd.buy_price_ht) * fd.qty) AS avg_profit
                 FROM {$db_prefix}facturedet fd
                 JOIN {$db_prefix}facture f ON f.rowid = fd.fk_facture
                 JOIN {$db_prefix}product p ON p.rowid = fd.fk_product
                 WHERE f.fk_statut = 2 AND YEAR(f.datef) < $current_year
                 GROUP BY p.label";
$res_avg_prod = $db->query($sql_avg_prod);
if ($res_avg_prod) {
    while ($row = $db->fetch_object($res_avg_prod)) {
        $average_product_profits[$row->label] = round($row->avg_profit, 2);
    }
}

$sql_avg_loc = "SELECT w.ref, AVG((fd.subprice - fd.buy_price_ht) * fd.qty) AS avg_profit
                FROM {$db_prefix}facturedet fd
                JOIN {$db_prefix}facture f ON f.rowid = fd.fk_facture
                JOIN {$db_prefix}user u ON u.rowid = f.fk_user_author
                JOIN {$db_prefix}entrepot w ON w.rowid = u.fk_warehouse
                WHERE f.fk_statut = 2 AND YEAR(f.datef) < $current_year
                GROUP BY w.ref";
$res_avg_loc = $db->query($sql_avg_loc);
if ($res_avg_loc) {
    while ($row = $db->fetch_object($res_avg_loc)) {
        $average_location_profits[$row->ref] = round($row->avg_profit, 2);
    }
}

// 🔮 Forecast Table Function with Evaluation + Toggle
function generateDynamicForecast($monthly_profits) {
    ksort($monthly_profits);
    $months = array_keys($monthly_profits);
    $output = "<button onclick=\"toggleForecasts()\">Show/Hide Past Forecasts</button>
    <div id='forecastContainer'>";

   for ($i = 2; $i < count($months); $i++) {
    $last3 = array_slice($months, $i - 2, 3);
    $last3_profits = array_map(function($m) use ($monthly_profits) {
        return $monthly_profits[$m];
    }, $last3);

        $highest_profit = max($last3_profits);
        $highest_month = $last3[array_search($highest_profit, $last3)];
        $average_profit = round(array_sum($last3_profits) / 3, 2);
        $forecast_month = date("Y-m", strtotime($months[$i] . "-01 +1 month"));
        $forecast_value = round($average_profit);

        $actual_value = $monthly_profits[$forecast_month] ?? null;
        $status = '';
        if ($actual_value !== null) {
            $diff = $actual_value - $forecast_value;
            $percent = round(($diff / $forecast_value) * 100, 2);
            if ($percent > 10) {
                $status = "$percent% profit increase from projection: 🎉 Congratulations";
            } elseif ($percent < -10) {
                $status = "$percent% drop from projection: ⚠️ Below forecast";
            } else {
                $status = "$percent% change from projection: 📊 On target";
            }
        }

        $output .= "<div class='forecast-block' style='margin-bottom:30px;'>
        <h3>📌 Profit Summary (Last 3 Months)</h3>
        <table border='1' cellpadding='5'>
            <tr><th>Month</th><th>Profit</th></tr>";
        foreach ($last3 as $m) {
            $output .= "<tr><td>$m</td><td>₦" . number_format($monthly_profits[$m]) . "</td></tr>";
        }
        $output .= "</table>
        <p><strong>Highest Profit:</strong> $highest_month – ₦" . number_format($highest_profit) . "<br>
        <strong>Average Profit:</strong> ₦" . number_format($average_profit) . "<br>
        <strong>📈 Forecast for $forecast_month:</strong> ₦" . number_format($forecast_value) . " (Benchmark)</p>";

        if ($actual_value !== null) {
            $output .= "<h3>🧾 Evaluation Station</h3>
            <table border='1' cellpadding='5'>
                <tr><th>Metric</th><th>Value</th></tr>
                <tr><td>$forecast_month Projection</td><td>₦" . number_format($forecast_value) . "</td></tr>
                <tr><td>$forecast_month Actual</td><td>₦" . number_format($actual_value) . "</td></tr>
                <tr><td>Status</td><td>$status</td></tr>
            </table><br><hr><br>";
        } else {
            $output .= "<p><em>Awaiting actual profit for $forecast_month to evaluate forecast.</em></p><hr><br>";
        }

        $output .= "</div>";
    }

    $output .= "</div>
    <script>
    function toggleForecasts() {
        var container = document.getElementById('forecastContainer');
        container.style.display = (container.style.display === 'none') ? 'block' : 'none';
    }
    </script>";

    return $output;
}

// 🔍 Current Product Profits & Alerts
$product_labels = [];
$product_profits = [];
$product_percentages = [];
$product_severity_levels = [];
$alerts = [];

$severityMap = [1 => '⚠️ Warning', 2 => '🚨 Critical'];

$db_prefix = defined('MAIN_DB_PREFIX') ? rtrim(MAIN_DB_PREFIX, '_') . '_' : 'ok_';

$sql_prod = "SELECT p.label, SUM((fd.subprice - fd.buy_price_ht) * fd.qty) AS profit
             FROM {$db_prefix}facturedet fd
             JOIN {$db_prefix}facture f ON f.rowid = fd.fk_facture
             JOIN {$db_prefix}product p ON p.rowid = fd.fk_product
             WHERE f.fk_statut = 2
             GROUP BY p.label
             ORDER BY profit DESC
             LIMIT 7";
$res_prod = $db->query($sql_prod);
$total_product_profit = 0;

if ($res_prod) {
    while ($obj = $db->fetch_object($res_prod)) {
        $label = $obj->label;
        $profit = round($obj->profit, 2);
        $avg = $average_product_profits[$label] ?? 0;
        $drop = ($avg > 0) ? round((1 - $profit / $avg) * 100) : 0;

        $product_labels[] = $label;
        $product_profits[] = $profit;
        $total_product_profit += $profit;

        $severity = ($avg > 0 && $profit < $avg * 0.5) ? 2 : (($avg > 0 && $profit < $avg * 0.8) ? 1 : 0);
        $product_severity_levels[] = $severity;

        if ($severity > 0) {
    $alerts[] = "{$severityMap[$severity]} <strong>$label</strong> — Current Profit: ₦" . number_format($profit, 0) .
                ", Expected: ₦" . number_format($avg, 0) . ". Drop: {$drop}%. Review pricing and demand strategy.";
}
    }
}

// 🔍 Unsold Products (Last 30 Days) — Enhanced with last sold date and average sales

$unsold_products = [];

$db_prefix = defined('MAIN_DB_PREFIX') ? rtrim(MAIN_DB_PREFIX, '_') . '_' : 'ok_';

$sql_unsold = "
  SELECT p.label,
         MAX(f.datef) AS last_sold,
         ROUND(SUM((fd.subprice - fd.buy_price_ht) * fd.qty) / COUNT(DISTINCT MONTH(f.datef)), 2) AS avg_monthly_profit
  FROM {$db_prefix}product p
  LEFT JOIN {$db_prefix}facturedet fd ON p.rowid = fd.fk_product
  LEFT JOIN {$db_prefix}facture f ON f.rowid = fd.fk_facture AND f.fk_statut = 2
  GROUP BY p.label
  HAVING MAX(f.datef) < DATE_SUB(CURDATE(), INTERVAL 30 DAY) OR MAX(f.datef) IS NULL
";

$res_unsold = $db->query($sql_unsold);
if ($res_unsold && $res_unsold->num_rows > 0) {
    while ($row = $res_unsold->fetch_assoc()) {
        $label = $row['label'];
        $last_sold = $row['last_sold'] ? date('F Y', strtotime($row['last_sold'])) : 'Never';
        $avg_profit = $row['avg_monthly_profit'] ?? 0;
        $unsold_products[] = $label;
        $alerts[] = "📦 <strong>{$label}</strong> — No sales in the last 30 days. Last sold: {$last_sold}. Avg monthly profit: ₦" . number_format($avg_profit, 0) . ". Consider reviewing visibility, pricing, or demand.";
    }
}

// 🔍 Product Percentages
$product_percentages = array_map(function($val) use ($total_product_profit) {
    return $total_product_profit > 0 ? round(($val / $total_product_profit) * 100, 1) : 0;
}, $product_profits);

// 🔍 Current Location Profits & Alerts
$location_labels = [];
$location_profits = [];
$location_percentages = [];
$location_severity_levels = [];

$db_prefix = defined('MAIN_DB_PREFIX') ? rtrim(MAIN_DB_PREFIX, '_') . '_' : 'ok_';

$sql_loc = "SELECT w.ref AS location, SUM((fd.subprice - fd.buy_price_ht) * fd.qty) AS profit
            FROM {$db_prefix}facturedet fd
            JOIN {$db_prefix}facture f ON f.rowid = fd.fk_facture
            JOIN {$db_prefix}user u ON u.rowid = f.fk_user_author
            JOIN {$db_prefix}entrepot w ON w.rowid = u.fk_warehouse
            WHERE f.fk_statut = 2
            GROUP BY w.ref
            ORDER BY profit DESC
            LIMIT 7";
            
$res_loc = $db->query($sql_loc);
$total_location_profit = 0;

if ($res_loc) {
    while ($obj = $db->fetch_object($res_loc)) {
        $loc = $obj->location ?: 'Unknown';
        $profit = round($obj->profit, 2);
        $avg = $average_location_profits[$loc] ?? 0;
        $drop = ($avg > 0) ? round((1 - $profit / $avg) * 100) : 0;

        $location_labels[] = $loc;
        $location_profits[] = $profit;
        $total_location_profit += $profit;

        $severity = ($avg > 0 && $profit < $avg * 0.5) ? 2 : (($avg > 0 && $profit < $avg * 0.8) ? 1 : 0);
        $location_severity_levels[] = $severity;

        if ($severity > 0) {
            $alerts[] = "{$severityMap[$severity]} <strong>$loc</strong> — Current Profit: ₦" . number_format($profit) .
                        ", Expected: ₦" . number_format($avg) . ". Drop: {$drop}% below target. " .
                        "Review recommended — possible expense spike or low-margin sales.";
        }

        // 🔍 Expense Spike Detection
      $expense_threshold = $avg * 1.2;

$db_prefix = defined('MAIN_DB_PREFIX') ? rtrim(MAIN_DB_PREFIX, '_') . '_' : 'ok_';

$sql_expense_spike = "SELECT SUM(total_ttc) AS total FROM {$db_prefix}expensereport
                      WHERE fk_statut = 6 AND fk_warehouse = (
                          SELECT rowid FROM {$db_prefix}entrepot WHERE ref = '$loc'
                      ) AND date_valid >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";
                      
        $res_expense = $db->query($sql_expense_spike);
        if ($res_expense && ($row = $db->fetch_object($res_expense)) && $row->total > $expense_threshold) {
            $alerts[] = "⚠️ <strong>$loc</strong> — Expenses in last 30 days: ₦" . number_format($row->total) .
                        ", which exceeds 120% of expected profit (₦" . number_format($avg) . "). Investigate unusual activity.";
        }

        // 🔍 Breakeven Risk
        if ($avg > 0 && $profit < $avg * 0.4) {
            $alerts[] = "⚠️ <strong>$loc</strong> — Current Profit: ₦" . number_format($profit) .
                        ", Expected: ₦" . number_format($avg) . ". Drop: {$drop}% below target. " .
                        "Breakeven risk — review cost structure and pricing.";
        }
    }

    // 🔢 Location Percentages
    $location_percentages = array_map(function($val) use ($total_location_profit) {
        return $total_location_profit > 0 ? round(($val / $total_location_profit) * 100, 1) : 0;
    }, $location_profits);
}

// 🧾 Alert Display Helper
function renderAlerts($alerts) {
    if (empty($alerts)) return "<p>No alerts at this time. ✅</p>";

    $html = "<div style='background:#fff8e1; border:1px solid #f0c36d; padding:15px; margin-top:20px;'>
                <h3>📢 Alerts & Recommendations</h3>
                <ul>";
    foreach ($alerts as $alert) {
        $html .= "<li style='margin-bottom:10px;'>$alert</li>";
    }
    $html .= "</ul></div>";

    return $html;
}


// 🔍 Filter severity levels for chart rendering only
$filtered_product_labels = [];
$filtered_product_severity = [];

foreach ($results as $row) {
  $current = $row['current_profit'];
  $average = $row['average_profit'];
  $severity = 0;

  if ($current < 0.8 * $average) {
    $severity = 1;
  }
  if ($current < 0.5 * $average) {
    $severity = 2;
  }

  if ($severity > 0) {
    $filtered_product_labels[] = $row['product'];
    $filtered_product_severity[] = $severity;
  }
}

$filtered_location_labels = [];
$filtered_location_severity = [];
foreach ($location_labels as $i => $label) {
    if ($location_severity_levels[$i] > 0) {
        $filtered_location_labels[] = $label;
        $filtered_location_severity[] = $location_severity_levels[$i];
    }
}

// 🔍 Severity Alerts (Demo Injection with Enhanced Format)
$filtered_product_labels = ["Adire-Thick-Blend", "Linen-Plain-Thick", "Adira-Normal-Blend"];
$filtered_product_profits = [18200, 25000, 42000];
$filtered_product_expected = [42000, 31000, 42000];

$filtered_location_labels = ["Lagos", "Abuja", "Port Harcourt"];
$filtered_location_profits = [58000, 41000, 72000];
$filtered_location_expected = [69000, 58000, 72000];

foreach ($filtered_product_labels as $i => $label) {
    $profit = $filtered_product_profits[$i];
    $avg = $filtered_product_expected[$i];
    $drop = ($avg > 0) ? round((1 - $profit / $avg) * 100) : 0;
    $level = ($avg > 0 && $profit < $avg * 0.5) ? 2 : (($avg > 0 && $profit < $avg * 0.8) ? 1 : 0);

    if ($level > 0) {
        $alerts[] = "{$severityMap[$level]} <strong>{$label}</strong> — Current Profit: ₦" . number_format($profit, 0) .
                    ", Expected: ₦" . number_format($avg, 0) . ". Drop: {$drop}%. Review pricing and demand strategy.";
    }
}

foreach ($filtered_location_labels as $i => $label) {
    $profit = $filtered_location_profits[$i];
    $avg = $filtered_location_expected[$i];
    $drop = ($avg > 0) ? round((1 - $profit / $avg) * 100) : 0;
    $level = ($avg > 0 && $profit < $avg * 0.5) ? 2 : (($avg > 0 && $profit < $avg * 0.8) ? 1 : 0);

    if ($level > 0) {
        $alerts[] = "{$severityMap[$level]} <strong>{$label}</strong> — Current Profit: ₦" . number_format($profit, 0) .
                    ", Expected: ₦" . number_format($avg, 0) . ". Drop: {$drop}%. Investigate cost structure or margin pressure.";
    }
}
?>

<!-- 📊 Monthly Profit Trend, Top 3 Months & Forecast -->
<h2>📊 Monthly Profit Trend, Top 3 Months & Forecast</h2>

<div style="display:flex; justify-content:space-between; gap:20px; margin-top:30px; margin-bottom:30px;">
  <!-- Chart Panel -->
  <div style="flex: 1.1; padding: 15px; background:#f9f9f9; border-radius: 8px; box-shadow: 2px 2px 10px rgba(0,0,0,0.1);">
    <h3 style="text-align:center;">Monthly Profit Trend</h3>
    <canvas id="monthlyProfitChart" style="width:100%; height:300px;"></canvas>
  </div>

  <!-- Table Panel -->
  <div style="flex: 1; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
    <h3 style="text-align:center;">Top 3 Months</h3>
    <table class="noborder" style="width:100%; table-layout:fixed;">
      <tr class="liste_titre">
        <th>Month</th>
        <th>Net Profit (₦)</th>
      </tr>
      <?php foreach ($top_months as $month => $profit): ?>
      <tr>
        <td><?php echo $month; ?></td>
        <td>
          <span style="color:<?php echo $profit < 0 ? 'red' : 'green'; ?>">
            <?php echo ($profit < 0 ? '▼' : '▲') . ' ₦' . number_format(abs($profit), 2); ?>
          </span>
        </td>
      </tr>
      <?php endforeach; ?>
    </table>
  </div>
</div>

<?php if (!empty($monthly_profits) && is_array($monthly_profits)): ?>
  <!-- ✅ Your forecast panel code goes here -->
<?php else: ?>
  <div style="margin-top:30px; padding:15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
    <h3>📈 Forecast Intelligence Center</h3>
    <p><em>No profit data available to generate forecast.</em></p>
  </div>
<?php endif; ?>



  <!-- Forecast Panel -->
<!-- 🔮 Enhanced Forecast Information Center -->
<div style="flex: 0.8; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
  <?php
    ksort($monthly_profits);
    $months = array_keys($monthly_profits);
    $last3 = array_slice($months, -3);
    $last3_profits = array_map(function($m) use ($monthly_profits) {
        return $monthly_profits[$m];
    }, $last3);

    $average_profit = round(array_sum($last3_profits) / 3, 2);
    $forecast_month = date("Y-m", strtotime("first day of next month"));
    $forecast_value = round($average_profit);
    $actual_value = $monthly_profits[$forecast_month] ?? null;

    $status = '';
    $deviation = null;
    $color = 'black';
    if ($actual_value !== null) {
        $diff = $actual_value - $forecast_value;
        $deviation = round(($diff / $forecast_value) * 100, 2);
        if ($deviation > 10) {
            $status = "+$deviation% Profit Increase 🎉 Congratulations";
            $color = 'green';
        } elseif ($deviation < -10) {
            $status = "$deviation% Drop ⚠️ Below Forecast";
            $color = 'red';
        } else {
            $status = "$deviation% Change 📊 On Target";
            $color = 'orange';
        }
    }
  ?>

  <h3 style="text-align:center;">📈 Forecast for <?php echo date("M Y", strtotime($forecast_month)); ?></h3>
  <p style="text-align:center;">Expected Net Profit: <strong>₦<?php echo number_format($forecast_value, 2); ?></strong></p>
  <p style="text-align:center; font-size:0.9em;">
    Based on average of last 3 months: </p>
 <ul style="list-style:none; padding-left:0; text-align:center; font-size:0.9em;">   
    <?php  foreach ($last3 as $m): ?>
    <li><?php echo date("M Y", strtotime($m)); ?> – ₦<?php echo number_format($monthly_profits[$m]); ?></li>
  <?php endforeach; ?>
</ul>
 
  <?php if ($actual_value !== null): ?>
    <p style="text-align:center; font-size:0.9em; color:<?php echo $color; ?>">
      Actual for <?php echo date("M Y", strtotime($forecast_month)); ?>: ₦<?php echo number_format($actual_value); ?><br>
      <strong><?php echo $status; ?></strong>
    </p>
  <?php else: ?>
    <p style="text-align:center; font-size:0.9em;">
      <em>Awaiting actual profit for <?php echo date("M Y", strtotime($forecast_month)); ?> to evaluate forecast.</em>
    </p>
  <?php endif; ?>

  <!-- 🔘 Toggle Button for Past Forecasts -->
  <div style="text-align:center; margin-top:20px;">
    <button onclick="toggleForecasts()" style="padding:6px 12px; border-radius:4px;">Show/Hide Past Forecasts</button>
  </div>
  <div id="forecastContainer" style="display:none; margin-top:20px;">
    
    
    <?php
    
      for ($i = count($months) - 1; $i >= 2; $i--) {
          $window = array_slice($months, $i - 2, 3);
          $profits = array_map(function($m) use ($monthly_profits) {
              return $monthly_profits[$m];
          }, $window);

          $highest = max($profits);
          $highest_month = $window[array_search($highest, $profits)];
          $avg = round(array_sum($profits) / 3, 2);
          $next = date("Y-m", strtotime($months[$i] . "-01 +1 month"));
          $next_label = date("M Y", strtotime($next));
          $forecast = round($avg);
          $actual = $monthly_profits[$next] ?? null;

          echo "<div style='margin-bottom:20px; border-top:1px solid #ccc; padding-top:10px;'>
                <h4>📌 Profit Summary (Last 3 Months)</h4>
                <table border='1' cellpadding='5' style='width:100%; text-align:center;'>
                  <tr><th>Month</th><th>Profit</th></tr>";
          foreach ($window as $m) {
              echo "<tr><td>$m</td><td>₦" . number_format($monthly_profits[$m]) . "</td></tr>";
          }
          echo "</table>
                <p><strong>Highest Profit:</strong> $highest_month – ₦" . number_format($highest) . "<br>
                <strong>Average Profit:</strong> ₦" . number_format($avg) . "<br>
                <strong>📈 Forecast for $next_label:</strong> ₦" . number_format($forecast) . " (Benchmark)</p>";
                
                echo "<canvas id='trendChart_$next' width='120' height='40' style='margin-top:10px;'></canvas>";

          if ($actual !== null) {
              $diff = $actual - $forecast;
              $percent = round(($diff / $forecast) * 100, 2);
              $msg = ($percent > 10) ? "🎉 Congratulations" :
                     (($percent < -10) ? "⚠️ Below Forecast" : "📊 On Target");
              $color = ($percent > 10) ? 'green' : (($percent < -10) ? 'red' : 'orange');

              echo "<h4>🧾 Evaluation Station</h4>
                    <table border='1' cellpadding='5' style='width:100%; text-align:center;'>
                      <tr><th>Metric</th><th>Value</th></tr>
                      <tr><td>$next_label Projection</td><td>₦" . number_format($forecast) . "</td></tr>
                      <tr><td>$next_label Actual</td><td>₦" . number_format($actual) . "</td></tr>";
                     
                      $diff = $actual - $forecast;
                      $percent = round(($diff / $forecast) * 100, 2);
                    $arrow = ($percent > 10) ? '▲' : (($percent < -10) ? '▼' : '➖');
                    $msg = ($percent > 10) ? "🎉 Congratulations" :
                  (($percent < -10) ? "⚠️ Below Forecast" : "📊 On Target");
$color = ($percent > 10) ? 'green' : (($percent < -10) ? 'red' : 'orange');

echo "<tr><td>Status</td><td style='color:$color;'>$arrow $percent% change — $msg</td></tr>";
echo "</table>";
                    
          } else {
              echo "<p><em>Awaiting actual profit for $next_label to evaluate forecast.</em></p>";
          }

          echo "</div>";
      }
    ?>

<?php
$labels = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
$forecastData = [];
$actualData = [];

$year = date('Y');

foreach ($labels as $monthName) {
    $key = date("Y-m", strtotime("$monthName $year"));

    // Calculate forecast if we have at least 3 months before this one
    $monthIndex = array_search($key, $months);
    if ($monthIndex !== false && $monthIndex >= 2) {
        $window = array_slice($months, $monthIndex - 2, 3);
        $forecast = round(array_sum(array_map(function($m) use ($monthly_profits) {
            return $monthly_profits[$m];
        }, $window)) / 3, 2);
    } else {
        $forecast = null;
    }

    $actual = $monthly_profits[$key] ?? null;

    $forecastData[] = is_numeric($forecast) ? (float)$forecast : null;
    $actualData[] = is_numeric($actual) ? (float)$actual : null;
}
?>
    
  </div>
</div>

<h3 style="text-align:center;">📊 Forecast vs Actual Profit (Monthly Trend)</h3>
<canvas id="multiMonthChart" width="600" height="300" style="margin:auto; display:block;"></canvas>

<script>
function toggleForecasts() {
  var container = document.getElementById('forecastContainer');
  container.style.display = (container.style.display === 'none') ? 'block' : 'none';
}
</script>

<!-- 🔔 Alerts & Strategic Signals -->
<h2>🔔 Alerts & Strategic Signals</h2>
<div style="padding:15px; background:#fff; border:1px solid #ccc; border-radius:6px;">

<?php
// 🔍 Severity Flags
$has_critical = in_array(2, $filtered_product_severity) || in_array(2, $filtered_location_severity);
$has_warning = in_array(1, $filtered_product_severity) || in_array(1, $filtered_location_severity);

// 🔍 Executive Summary
$critical_count = count(array_filter($filtered_product_severity, function($s) { return $s === 2; })) +
                  count(array_filter($filtered_location_severity, function($s) { return $s === 2; }));
$warning_count = count(array_filter($filtered_product_severity, function($s) { return $s === 1; })) +
                 count(array_filter($filtered_location_severity, function($s) { return $s === 1; }));
$top_issues = array_slice($filtered_product_labels, 0, 3);

echo "<p><strong>🧠 Executive Summary:</strong> $critical_count critical, $warning_count warning alerts. Top issues: " . implode(', ', $top_issues) . ".</p>";

// 🔍 Merge Forecast Alerts
$alerts = array_merge($forecast_alerts, $alerts);

// 🔍 Grouped Display
if (!empty($alerts)) {
    echo "<details open><summary><strong>📦 Product Alerts</strong></summary><ul>";
    foreach ($alerts as $alert) {
        if (strpos($alert, 'Product') !== false || strpos($alert, '📦') !== false) {
            echo "<li style='margin-bottom:10px; background:#fff3cd; padding:10px; border-left:5px solid #ffc107;'>$alert</li>";
        }
    }
    echo "</ul></details>";

    echo "<details><summary><strong>📍 Location Alerts</strong></summary><ul>";
    foreach ($alerts as $alert) {
        if (strpos($alert, 'Location') !== false || strpos($alert, 'Warehouse') !== false) {
            echo "<li style='margin-bottom:10px; background:#fff3cd; padding:10px; border-left:5px solid #ffc107;'>$alert</li>";
        }
    }
    echo "</ul></details>";

    echo "<details><summary><strong>📉 Forecast Alerts</strong></summary><ul>";
    foreach ($alerts as $alert) {
        if (strpos($alert, 'Forecast') !== false) {
            echo "<li style='margin-bottom:10px; background:#e2e3e5; padding:10px; border-left:5px solid #6c757d;'>$alert</li>";
        }
    }
    echo "</ul></details>";
} else {
    echo "<p style='color:green;'>✅ All systems normal. No alerts at this time.</p>";
}

// 🔍 Severity Banners
if ($has_critical) {
    echo "<p style='margin-top:15px; background:#f8d7da; padding:10px; border-left:5px solid #dc3545;'>
          🚨 Critical issues detected in specific products or locations. Immediate action recommended.
          </p>";
}

if ($has_warning) {
    echo "<p style='margin-top:10px; background:#fff3cd; padding:10px; border-left:5px solid #ffc107;'>
          ⚠️ Warning-level performance observed. Review flagged items for improvement.
          </p>";
}
?>
</div>

<!-- ✅ Alert Severity Charts -->
<h2>🚦 Alert Severity Charts</h2>
<div style="display:flex; justify-content:space-between; gap:20px; margin-top:30px; margin-bottom:30px;">
  <div style="flex: 1; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
    <h3 style="text-align:center;">Product Alert Severity</h3>
    <canvas id="productAlertChart" style="max-height:240px;"></canvas>
  </div>
  <div style="flex: 1; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
    <h3 style="text-align:center;">Location Alert Severity</h3>
    <canvas id="locationAlertChart" style="max-height:240px;"></canvas>
  </div>
</div>

<!-- 📦 Unsold Products -->
<div style="margin-top:30px;">
  <h3>📦 Unsold Products (Last 30 Days)</h3>
  <canvas id="unsoldProductsChart" style="max-height:240px;"></canvas>
</div>

<!-- ✅ Row 1: Product Breakdown -->
<div style="display:flex; justify-content:space-between; gap:20px; margin-top:30px; margin-bottom:30px;">
  <div style="flex: 1; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
    <h3 style="text-align:center;">Profit by Product</h3>
    <canvas id="productBarChart" style="max-height:240px;"></canvas>
  </div>
  <div style="flex: 1; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
    <h3 style="text-align:center;">% Profit by Product</h3>
    <canvas id="categoryPieChart" style="max-height:240px;"></canvas>
  </div>
</div>

<!-- ✅ Row 2: Location Breakdown -->
<div style="display:flex; justify-content:space-between; gap:20px; margin-top:30px; margin-bottom:30px;">
  <div style="flex: 1; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
    <h3 style="text-align:center;">Profit by Location</h3>
    <canvas id="locationBarChart" style="max-height:240px;"></canvas>
  </div>
  <div style="flex: 1; padding: 15px; background:#fff; border:1px solid #ccc; border-radius:6px;">
    <h3 style="text-align:center;">% Profit by Location</h3>
    <canvas id="locationPieChart" style="max-height:240px;"></canvas>
  </div>
</div>

<!-- 🔍 Chart Data Sync -->
<script>
  const monthlyLabels = <?php echo $monthly_labels_json; ?>;
  const monthlyProfits = <?php echo $monthly_profit_json; ?>;

  const fullProductLabels = <?php echo json_encode($product_labels); ?>;
  const productProfits = <?php echo json_encode($product_profits); ?>;
  const productPercentages = <?php echo json_encode($product_percentages); ?>;

  const fullLocationLabels = <?php echo json_encode($location_labels); ?>;
  const locationProfits = <?php echo json_encode($location_profits); ?>;
  const locationPercentages = <?php echo json_encode($location_percentages); ?>;

  const unsoldProducts = <?php echo json_encode($unsold_products); ?>;
</script>

<!-- ✅ Declare severity variables with let -->
<script>
  let productLabels = <?php echo json_encode($filtered_product_labels); ?>;
  let productAlertSeverity = <?php echo json_encode($filtered_product_severity); ?>;
  let locationLabels = <?php echo json_encode($filtered_location_labels); ?>;
  let locationAlertSeverity = <?php echo json_encode($filtered_location_severity); ?>;
</script>

<!-- Chart.js core library -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>

<!-- Custom Chart Logic -->
<script src="/custom/js/pulseiq.js"></script>

<!-- ✅ Overwrite severity data for demo -->
<script>
  productLabels = ["Adire-Thick-Blend", "Linen-Plain-Thick", "Adira-Normal-Blend"];
  productAlertSeverity = [2, 1, 0];

  locationLabels = ["Lagos", "Abuja", "Port Harcourt"];
  locationAlertSeverity = [1, 2, 0];
</script>

<script>
document.addEventListener("DOMContentLoaded", function() {
<?php
for ($i = count($months) - 1; $i >= 2; $i--) {
    $window = [$months[$i - 2], $months[$i - 1], $months[$i]];
    $next = date("Y-m", strtotime($months[$i] . "-01 +1 month"));
    $data = array_map(function($m) use ($monthly_profits) {
    return $monthly_profits[$m];
}, $window);
    echo "new Chart(document.getElementById('trendChart_$next').getContext('2d'), {
      type: 'line',
      data: {
        labels: ['','',''],
        datasets: [{
          data: [" . implode(',', $data) . "],
          borderColor: '#007bff',
          fill: false,
          tension: 0.3
        }]
      },
      options: {
        responsive: false,
        plugins: { legend: { display: false } },
        scales: { x: { display: false }, y: { display: false } }
      }
    });\n";
}
?>
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
  new Chart(document.getElementById('multiMonthChart'), {
    type: 'line',
    data: {
      labels: <?php echo json_encode($labels); ?>,
      datasets: [
        {
          label: 'Forecast',
          data: <?php echo json_encode($forecastData); ?>,
          borderColor: '#007bff',
          backgroundColor: 'transparent',
          tension: 0.3
        },
        {
          label: 'Actual',
          data: <?php echo json_encode($actualData); ?>,
          borderColor: '#28a745',
          backgroundColor: 'transparent',
          tension: 0.3
        }
      ]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: true }
      },
      spanGaps: true,
      scales: {
        y: {
          beginAtZero: true,
          ticks: {
            callback: function(value) {
              return '₦' + value.toLocaleString();
            }
          }
        }
      }
    }
  });
});
</script>
