<?php
require_once '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

global $db, $user;

setEventMessages("✅ Massaction logic triggered", null, 'warnings');

$cost_update_value = GETPOST('updatecostprice', 'alpha');
$toselect = GETPOST('toselect', 'array');

if (empty($cost_update_value) || empty($toselect)) {
    setEventMessages('Missing value or selection.', null, 'warnings');
} else {
    $is_percentage = false;
    $rate = 0;

    if (strpos($cost_update_value, '%') !== false) {
        $is_percentage = true;
        $rate = floatval(str_replace('%', '', $cost_update_value));
        if (strpos($cost_update_value, '-') !== false) {
            $rate = -abs($rate);
        }
    } else {
        $rate = floatval($cost_update_value);
    }

    $nbok = 0;
    foreach ($toselect as $id) {
        $product = new Product($db);
        if ($product->fetch($id) > 0) {
            $newcost = $product->cost_price;
            $newcost = $is_percentage ? $newcost * (1 + ($rate / 100)) : $newcost + $rate;
            if ($newcost < 0) $newcost = 0;

            $sql = "UPDATE ".MAIN_DB_PREFIX."product SET cost_price = ".floatval($newcost).", fk_user_modif = ".$user->id." WHERE rowid = ".$id;
            if ($db->query($sql)) {
                $nbok++;
            }
        }
    }

    setEventMessages("$nbok product(s) updated.", null, 'mesgs');
}