<?php
require '../../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';

// Security check
if (empty($user->admin) || $user->entity != 0) {
    accessforbidden();
}

$langs->load("admin");
$action = GETPOST('action', 'aZ09');

// Handle form submission
if ($action == 'setmaxusers') {
    // Manual CSRF token check
    if (empty($_POST['token']) || $_POST['token'] != $_SESSION['newtoken']) {
        accessforbidden('Invalid Token');
    }

    $maxUsers = GETPOST('USERLIMIT_MAX_USERS', 'int');
    $res = dolibarr_set_const($db, "USERLIMIT_MAX_USERS", $maxUsers, 'chaine', 0, '', $conf->entity);

    if ($res > 0) {
        setEventMessages($langs->trans("RecordSaved"), null, 'mesgs');
    }
}

// Get current value
$maxUsers = getDolGlobalInt("USERLIMIT_MAX_USERS", 50);

// Output page
llxHeader('', $langs->trans("User Limit Configuration"));
print load_fiche_titre($langs->trans("User Limit Configuration"), '', 'setup');

print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="setmaxusers">';

print '<table class="noborder centertable" width="50%">';
print '<tr class="liste_titre"><td>'.$langs->trans("Parameter").'</td><td>'.$langs->trans("Value").'</td></tr>';
print '<tr class="oddeven"><td>'.$langs->trans("Maximum number of users").'</td>';
print '<td><input type="number" name="USERLIMIT_MAX_USERS" value="'.$maxUsers.'"></td></tr>';
print '</table>';

print '<div class="center"><input type="submit" class="button" value="'.$langs->trans("Save").'"></div>';
print '</form>';

llxFooter();