// ✅ Register Chart.js Plugin
Chart.register(ChartDataLabels);

// ✅ Monthly Profit Trend (Line Chart)
function renderMonthlyProfitChart(labels, data) {
  const canvas = document.getElementById('monthlyProfitChart');
  if (!canvas) return;

  new Chart(canvas, {
    type: 'line',
    data: {
      labels,
      datasets: [{
        label: 'Monthly Net Profit',
        data,
        borderColor: '#1abc9c',
        backgroundColor: 'rgba(26, 188, 156, 0.2)',
        fill: true,
        tension: 0.3,
        pointRadius: 4,
        pointHoverRadius: 6
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: true },
        tooltip: {
          callbacks: {
            label: ctx => '₦' + ctx.formattedValue
          }
        }
      },
      scales: {
        y: {
          beginAtZero: true,
          ticks: {
            callback: val => '₦' + val
          }
        }
      }
    }
  });
}

// ✅ Product Profit (Bar Chart)
function renderProductBarChart(labels, data) {
  const canvas = document.getElementById("productBarChart");
  if (!canvas) return;

  new Chart(canvas, {
    type: "bar",
    data: {
      labels,
      datasets: [{
        label: "₦ Profit",
        data,
        backgroundColor: "#4e79a7"
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: false },
        tooltip: {
          callbacks: {
            label: ctx => '₦' + ctx.formattedValue
          }
        }
      },
      scales: {
        y: { beginAtZero: true }
      }
    }
  });
}

// ✅ Product Profit % (Pie Chart)
function renderProductPieChart(labels, percentages) {
  const canvas = document.getElementById("categoryPieChart");
  if (!canvas) return;

  new Chart(canvas, {
    type: "pie",
    data: {
      labels,
      datasets: [{
        data: percentages,
        backgroundColor: ["#76b7b2", "#e15759", "#edc948", "#59a14f", "#af7aa1", "#ff9da7", "#9c755f"]
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: "bottom" },
        tooltip: {
          callbacks: {
            label: ctx => `${ctx.label}: ${ctx.formattedValue}%`
          }
        },
        datalabels: {
          color: '#000',
          formatter: val => val + '%',
          font: { weight: 'bold' }
        }
      }
    }
  });
}

// ✅ Location Profit (Bar Chart)
function renderLocationBarChart(labels, data) {
  const canvas = document.getElementById("locationBarChart");
  if (!canvas) return;

  new Chart(canvas, {
    type: "bar",
    data: {
      labels,
      datasets: [{
        label: "₦ Profit",
        data,
        backgroundColor: "#f28e2b"
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: false },
        tooltip: {
          callbacks: {
            label: ctx => '₦' + ctx.formattedValue
          }
        }
      },
      scales: {
        y: { beginAtZero: true }
      }
    }
  });
}

// ✅ Location Profit % (Pie Chart)
function renderLocationPieChart(labels, percentages) {
  const canvas = document.getElementById("locationPieChart");
  if (!canvas) return;

  new Chart(canvas, {
    type: "pie",
    data: {
      labels,
      datasets: [{
        data: percentages,
        backgroundColor: ["#f28e2b", "#76b7b2", "#e15759", "#edc948", "#59a14f", "#af7aa1", "#9c755f"]
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: "bottom" },
        tooltip: {
          callbacks: {
            label: ctx => `${ctx.label}: ${ctx.formattedValue}%`
          }
        },
        datalabels: {
          color: '#000',
          formatter: val => val + '%',
          font: { weight: 'bold' }
        }
      }
    }
  });
}

// ✅ Alert Severity Charts
function renderAlertSeverityCharts() {
  function getSeverityColor(level) {
    return level === 2 ? 'red' : level === 1 ? 'orange' : 'green';
  }

  const filteredProductLabels = [];
  const filteredProductSeverity = [];
  productAlertSeverity.forEach((level, i) => {
    if (level > 0) {
      filteredProductLabels.push(productLabels[i]);
      filteredProductSeverity.push(level);
    }
  });

  const filteredLocationLabels = [];
  const filteredLocationSeverity = [];
  locationAlertSeverity.forEach((level, i) => {
    if (level > 0) {
      filteredLocationLabels.push(locationLabels[i]);
      filteredLocationSeverity.push(level);
    }
  });

  // ✅ Render Product Alert Chart
  const productCanvas = document.getElementById('productAlertChart');
  if (productCanvas && filteredProductLabels.length > 0) {
    new Chart(productCanvas, {
      type: 'bar',
      data: {
        labels: filteredProductLabels,
        datasets: [{
          label: 'Severity',
          data: filteredProductSeverity,
          backgroundColor: filteredProductSeverity.map(getSeverityColor)
        }]
      },
      options: {
        responsive: true,
        plugins: {
          title: {
            display: true,
            text: 'Product Alert Severity',
            color: 'red'
          },
          tooltip: {
            callbacks: {
              label: ctx => ['Normal', 'Warning', 'Critical'][ctx.raw]
            }
          }
        },
        scales: {
          y: {
            beginAtZero: true,
            max: 2,
            ticks: {
              stepSize: 1,
              callback: val => ['Normal', 'Warning', 'Critical'][val]
            }
          }
        }
      }
    });
  }

  // ✅ Render Location Alert Chart
  const locationCanvas = document.getElementById('locationAlertChart');
  if (locationCanvas && filteredLocationLabels.length > 0) {
    new Chart(locationCanvas, {
      type: 'bar',
      data: {
        labels: filteredLocationLabels,
        datasets: [{
          label: 'Severity',
          data: filteredLocationSeverity,
          backgroundColor: filteredLocationSeverity.map(getSeverityColor)
        }]
      },
      options: {
        responsive: true,
        plugins: {
          title: {
            display: true,
            text: 'Location Alert Severity',
            color: 'red'
          },
          tooltip: {
            callbacks: {
              label: ctx => ['Normal', 'Warning', 'Critical'][ctx.raw]
            }
          }
        },
        scales: {
          y: {
            beginAtZero: true,
            max: 2,
            ticks: {
              stepSize: 1,
              callback: val => ['Normal', 'Warning', 'Critical'][val]
            }
          }
        }
      }
    });
  }
}

// ✅ Unsold Products Chart
function renderUnsoldProductsChart() {
  const canvas = document.getElementById("unsoldProductsChart");
  if (!canvas || !unsoldProducts || unsoldProducts.length === 0) return;

  new Chart(canvas, {
    type: "bar",
    data: {
      labels: unsoldProducts,
      datasets: [{
        label: "No Sales",
        data: unsoldProducts.map(() => 1),
        backgroundColor: "#dc3545"
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: false },
        title: {
          display: true,
          text: "Unsold Products (Last 30 Days)"
        },
        tooltip: {
          callbacks: {
            label: () => "No sales recorded"
          }
        }
      },
      scales: {
        y: {
          beginAtZero: true,
          ticks: {
            stepSize: 1,
            callback: () => ""
          }
        }
      }
    }
  });
}

// ✅ Chart Triggers (now safe to run)

document.addEventListener("DOMContentLoaded", function () {
  if (Array.isArray(monthlyLabels) && monthlyLabels.length > 0 &&
      Array.isArray(monthlyProfits) && monthlyProfits.length > 0) {
    renderMonthlyProfitChart(monthlyLabels, monthlyProfits);
  }

  if (Array.isArray(fullProductLabels) && fullProductLabels.length > 0 &&
      Array.isArray(productProfits) && productProfits.length > 0) {
    renderProductBarChart(fullProductLabels, productProfits);
    renderProductPieChart(fullProductLabels, productPercentages);
  }

  if (Array.isArray(fullLocationLabels) && fullLocationLabels.length > 0 &&
      Array.isArray(locationProfits) && locationProfits.length > 0) {
    renderLocationBarChart(fullLocationLabels, locationProfits);
    renderLocationPieChart(fullLocationLabels, locationPercentages);
  }

  renderAlertSeverityCharts();
  renderUnsoldProductsChart();
});

console.log("Severity Data:", {
  productLabels,
  productAlertSeverity,
  locationLabels,
  locationAlertSeverity
});